/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Construction 
**
** DESCRIPTION:	Construction of houses and other constructions
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef CONSTRUCTION_H
#define CONSTRUCTION_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "Puzzle.h"
#include "../World/ContentMap.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Construction_c_iMildDisrepair = 250;
const int Construction_c_iSignificantDisrepair = 1600; //was 600
const int Construction_c_iSevereDisrepair = 2000;	//was 1000

const ldwPoint Construction_c_sScaffoldingOffset[2] = {
	ldwPoint(0, 110),
	ldwPoint(88, 75)
};

const ldwPoint Construction_c_sChimneyOffset[4] = {
	ldwPoint(118, 23),
	ldwPoint(118, 23),
	ldwPoint(118, 23),
	ldwPoint(93, 23),
};

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum EConstruction
{
	eConstruction_House1 = 0,
	eConstruction_House2,
	eConstruction_House3,
	eConstruction_ClothingHut,
//	eConstruction_Hospital,

	eConstruction_NumberOf
};

enum EDisrepair
{
	eDisrepair_None = 0,
	eDisrepair_Mild,
	eDisrepair_Significant,
	eDisrepair_Severe,
	eDisrepair_NotBuilt,

	eDisrepair_NumberOf
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CConstruction : public IPuzzle
{
	friend class CPuzzle;

private:

	//class structures
	struct SConstruction
	{
		bool			m_bIsInProgress;
		EDisrepair		m_eInitialDisrepair;
		int				m_iInitialPointsRemaining;
		int				m_iSmoke;
		int				m_iFrame;
	};

	struct SSaveState
	{
		SConstruction	m_sConstruction[eConstruction_NumberOf];
	};

	//class data
	SConstruction	m_sConstruction[eConstruction_NumberOf];
	
	ldwImage *		m_pScaffolding;
	ldwImageGrid *	m_pHouse;
	ldwImageGrid *	m_pClothingHut;
	ldwImageGrid *	m_pHospital;

	//class methods
	//setup
	public:		CConstruction(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Refresh();
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Update();
	public:		void Advance(CVillager &Villager, const int iRef);

	// access
	public:		const CContentMap::EObject SiteObject(const EConstruction eConstruction) const;
	public:		const CContentMap::EObject Object(const EConstruction eConstruction) const;
	public:		const EPuzzle GetPuzzle(const EConstruction eConstruction) const;
	public:		const bool IsComplete(const EConstruction eConstruction) const;
	public:		const int PercentComplete(const EConstruction eConstruction) const;
	public:		const EDisrepair StateOfDisrepair(const EConstruction eConstruction) const;
	public:		void SetDisrepair(const EConstruction eConstruction, const EDisrepair eDisrepair);
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CConstruction		Construction;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/